<?php
// プリセットの読み込み
$presetsFile = __DIR__ . '/../../data/presets.json';
$presets = [];
if (file_exists($presetsFile)) {
    $presets = json_decode(file_get_contents($presetsFile), true) ?: [];
}
?>

<div class="page-header">
    <h1><i class="bi bi-file-text"></i> 記事生成（シンプル版）</h1>
    <p class="text-muted">最小限の機能で記事を生成します</p>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form id="generateForm">
                    <div class="mb-3">
                        <label for="title" class="form-label">記事タイトル</label>
                        <input type="text" class="form-control" id="title" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="model" class="form-label">AIモデル</label>
                        <select class="form-control" id="model">
                            <?php foreach ($config['models'] as $provider => $models): ?>
                                <optgroup label="<?php echo ucfirst($provider); ?>">
                                    <?php foreach ($models as $key => $model): ?>
                                        <option value="<?php echo htmlspecialchars($key); ?>">
                                            <?php echo htmlspecialchars($model['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="user_prompt" class="form-label">記事の内容</label>
                        <textarea class="form-control" id="user_prompt" rows="5" required></textarea>
                    </div>
                    
                    <button type="submit" class="btn btn-primary" id="generateBtn">
                        <i class="bi bi-magic"></i> 記事を生成
                    </button>
                </form>
            </div>
        </div>
        
        <!-- 結果表示 -->
        <div id="resultArea" class="mt-4" style="display: none;">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">生成結果</h5>
                </div>
                <div class="card-body" id="resultContent">
                    <!-- ここに結果が表示される -->
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// フォーム送信処理（最小限）
document.getElementById('generateForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const btn = document.getElementById('generateBtn');
    const originalText = btn.innerHTML;
    btn.disabled = true;
    btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>生成中...';
    
    try {
        // フォームデータ収集
        const formData = {
            title: document.getElementById('title').value,
            model: document.getElementById('model').value,
            user_prompt: document.getElementById('user_prompt').value,
            output_format: 'visual',
            temperature: 0.7,
            max_tokens: 16000,
            save_history: true,
            enable_perplexity: false,
            enable_images: false
        };
        
        // APIリクエスト
        const response = await fetch('../api/service.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                action: 'generate',
                ...formData
            })
        });
        
        const result = await response.json();
        
        if (result.success) {
            // 結果表示
            document.getElementById('resultArea').style.display = 'block';
            document.getElementById('resultContent').innerHTML = result.content;
            alert('記事生成が完了しました！');
        } else {
            alert('エラー: ' + result.error);
        }
        
    } catch (error) {
        alert('通信エラー: ' + error.message);
        console.error(error);
    } finally {
        btn.disabled = false;
        btn.innerHTML = originalText;
    }
});
</script>