<?php
// 設定の保存処理
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 必要な設定のみを保持する新しい配列を作成
    $newConfig = [
        'api_keys' => $config['api_keys'] ?? [],
        'dmm' => $config['dmm'] ?? [],
        'duga' => [
            'app_id' => $config['duga']['app_id'] ?? '',
            'agent_id' => $config['duga']['agent_id'] ?? '',
            'banner_id' => $config['duga']['banner_id'] ?? ''
        ],
        'admin_password' => $config['admin_password'] ?? 'admin',
        'session_timeout' => $config['session_timeout'] ?? 86400,
        'ftp_profiles' => $config['ftp_profiles'] ?? []
    ];
    
    // APIキー（新形式）の更新
    if (isset($_POST['openai_api_key']) && $_POST['openai_api_key'] !== '') {
        $newConfig['api_keys']['openai'] = $_POST['openai_api_key'];
    }
    if (isset($_POST['anthropic_api_key']) && $_POST['anthropic_api_key'] !== '') {
        $newConfig['api_keys']['claude'] = $_POST['anthropic_api_key'];
    }
    if (isset($_POST['google_api_key']) && $_POST['google_api_key'] !== '') {
        $newConfig['api_keys']['gemini'] = $_POST['google_api_key'];
    }
    if (isset($_POST['venice_api_key']) && $_POST['venice_api_key'] !== '') {
        $newConfig['api_keys']['venice'] = $_POST['venice_api_key'];
    }
    if (isset($_POST['perplexity_api_key']) && $_POST['perplexity_api_key'] !== '') {
        $newConfig['api_keys']['perplexity'] = $_POST['perplexity_api_key'];
    }
    
    // DMM設定（新形式）の更新
    if (isset($_POST['dmm_api_id']) && $_POST['dmm_api_id'] !== '') {
        $newConfig['dmm']['api_id'] = $_POST['dmm_api_id'];
    }
    if (isset($_POST['dmm_affiliate_id']) && $_POST['dmm_affiliate_id'] !== '') {
        $newConfig['dmm']['affiliate_id'] = $_POST['dmm_affiliate_id'];
    }
    
    // DUGA設定の更新
    if (isset($_POST['duga_app_id']) && $_POST['duga_app_id'] !== '') {
        $newConfig['duga']['app_id'] = $_POST['duga_app_id'];
    }
    if (isset($_POST['duga_agent_id']) && $_POST['duga_agent_id'] !== '') {
        $newConfig['duga']['agent_id'] = $_POST['duga_agent_id'];
    }
    if (isset($_POST['duga_banner_id']) && $_POST['duga_banner_id'] !== '') {
        $newConfig['duga']['banner_id'] = $_POST['duga_banner_id'];
    }
    
    // 旧形式のキーは削除
    unset($newConfig['openai_api_key']);
    unset($newConfig['anthropic_api_key']);
    unset($newConfig['google_api_key']);
    unset($newConfig['venice_api_key']);
    unset($newConfig['perplexity_api_key']);
    unset($newConfig['dmm_api_id']);
    unset($newConfig['dmm_affiliate_id']);
    
    
    // パスワード変更
    $passwordError = null;
    if (!empty($_POST['new_password'])) {
        // 現在のパスワードを確認
        if (empty($_POST['current_password'])) {
            $passwordError = '現在のパスワードを入力してください。';
        } elseif (!password_verify($_POST['current_password'], $config['admin_password'])) {
            $passwordError = '現在のパスワードが正しくありません。';
        } elseif (strlen($_POST['new_password']) < 8) {
            $passwordError = '新しいパスワードは8文字以上で設定してください。';
        } elseif ($_POST['new_password'] !== $_POST['confirm_password']) {
            $passwordError = '新しいパスワードと確認用パスワードが一致しません。';
        } else {
            $newConfig['admin_password'] = password_hash($_POST['new_password'], PASSWORD_DEFAULT);
        }
    }
    
    // パスワードエラーがない場合のみ保存
    if (!$passwordError) {
        // 設定を保存（新形式）
        $configContent = "<?php\n// 設定ファイル\n\n\$config = " . var_export($newConfig, true) . ";\n\n";
        $configContent .= "require_once __DIR__ . '/config.default.php';\n";
        $configContent .= "\$config = array_merge(\$defaultConfig, \$config);\n\n";
        $configContent .= "return \$config;\n?>";
        $configPath = __DIR__ . '/../../config.php';
        
        // ファイル書き込み権限チェック
        if (!is_writable($configPath) && file_exists($configPath)) {
            $message = 'エラー: config.phpへの書き込み権限がありません。';
            $messageType = 'danger';
        } else {
            // ファイル書き込み
            $result = file_put_contents($configPath, $configContent);
            if ($result === false) {
                $message = 'エラー: 設定の保存に失敗しました。';
                $messageType = 'danger';
            } else {
                $message = '設定を保存しました。';
                $messageType = 'success';
                $config = $newConfig; // 現在のページで反映
            }
        }
    } else {
        $message = $passwordError;
        $messageType = 'danger';
    }
}
?>

<div class="page-header">
    <h1><i class="bi bi-gear"></i> 設定</h1>
    <p class="text-muted">システムの各種設定を管理</p>
</div>

<?php if (isset($_GET['debug'])): ?>
<div class="alert alert-info">
    <h5>デバッグ情報</h5>
    <pre><?php 
    echo "api_keys:\n";
    print_r($config['api_keys'] ?? []);
    echo "\ndmm:\n";
    print_r($config['dmm'] ?? []);
    echo "\n旧形式のキー:\n";
    echo "openai_api_key: " . ($config['openai_api_key'] ?? 'なし') . "\n";
    echo "anthropic_api_key: " . ($config['anthropic_api_key'] ?? 'なし') . "\n";
    echo "dmm_api_id: " . ($config['dmm_api_id'] ?? 'なし') . "\n";
    echo "dmm_affiliate_id: " . ($config['dmm_affiliate_id'] ?? 'なし') . "\n";
    ?></pre>
</div>
<?php endif; ?>

<?php if (isset($message)): ?>
    <div class="alert alert-<?php echo $messageType ?? 'info'; ?> alert-dismissible fade show" role="alert">
        <i class="bi bi-<?php echo $messageType === 'success' ? 'check-circle' : ($messageType === 'danger' ? 'exclamation-triangle' : 'info-circle'); ?>"></i> <?php echo htmlspecialchars($message); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<form method="POST" class="settings-form">
    <div class="row">
        <div class="col-lg-8">
            
            <!-- APIキー設定 -->
            <div class="card mb-3">
                <div class="card-header py-2">
                    <h5 class="mb-0"><i class="bi bi-key"></i> APIキー設定</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="openai_api_key" class="form-label">OpenAI API Key</label>
                        <input type="password" class="form-control" id="openai_api_key" name="openai_api_key" 
                               placeholder="<?php 
                                   $hasOpenAI = (!empty($config['api_keys']['openai']) && $config['api_keys']['openai'] !== '') || 
                                              (!empty($config['openai_api_key']) && $config['openai_api_key'] !== '');
                                   echo $hasOpenAI ? '設定済み（変更する場合は新しいキーを入力）' : 'sk-...'; 
                               ?>">
                        <small class="text-muted">GPT-4.1 Turbo/Mini, DALL-E 3で使用</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="anthropic_api_key" class="form-label">Anthropic API Key</label>
                        <input type="password" class="form-control" id="anthropic_api_key" name="anthropic_api_key" 
                               placeholder="<?php 
                                   $hasAnthropic = (!empty($config['api_keys']['claude']) && $config['api_keys']['claude'] !== '') || 
                                                  (!empty($config['anthropic_api_key']) && $config['anthropic_api_key'] !== '');
                                   echo $hasAnthropic ? '設定済み（変更する場合は新しいキーを入力）' : 'sk-ant-...'; 
                               ?>">
                        <small class="text-muted">Claude 4.0 Sonnet/Haikuで使用</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="google_api_key" class="form-label">Google API Key</label>
                        <input type="password" class="form-control" id="google_api_key" name="google_api_key" 
                               placeholder="<?php 
                                   $hasGoogle = (!empty($config['api_keys']['gemini']) && $config['api_keys']['gemini'] !== '') || 
                                              (!empty($config['google_api_key']) && $config['google_api_key'] !== '');
                                   echo $hasGoogle ? '設定済み（変更する場合は新しいキーを入力）' : 'AIza...'; 
                               ?>">
                        <small class="text-muted">Gemini 2.5 Pro/Flash, Imagen 3で使用</small>
                    </div>
                    
                    <hr class="my-4">
                    
                    <h6 class="mb-3">追加API設定</h6>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="dmm_api_id" class="form-label">DMM API ID</label>
                            <input type="text" class="form-control" id="dmm_api_id" name="dmm_api_id" 
                                   placeholder="<?php 
                                       $hasDmmApiId = (!empty($config['dmm']['api_id']) && $config['dmm']['api_id'] !== '') || 
                                                     (!empty($config['dmm_api_id']) && $config['dmm_api_id'] !== '');
                                       echo $hasDmmApiId ? '設定済み（変更する場合は新しいIDを入力）' : 'API IDを入力'; 
                                   ?>">
                        </div>
                        <div class="col-md-6">
                            <label for="dmm_affiliate_id" class="form-label">DMMアフィリエイトID</label>
                            <input type="text" class="form-control" id="dmm_affiliate_id" name="dmm_affiliate_id" 
                                   placeholder="<?php 
                                       $hasDmmAffiliateId = (!empty($config['dmm']['affiliate_id']) && $config['dmm']['affiliate_id'] !== '') || 
                                                           (!empty($config['dmm_affiliate_id']) && $config['dmm_affiliate_id'] !== '');
                                       echo $hasDmmAffiliateId ? '設定済み（変更する場合は新しいIDを入力）' : 'アフィリエイトIDを入力'; 
                                   ?>">
                        </div>
                    </div>
                    <small class="text-muted d-block mb-3">DMM/FANZAの商品情報取得に使用</small>
                    
                    <hr class="my-3">
                    
                    <h6 class="mb-3">DUGA API設定</h6>
                    <div class="mb-3">
                        <label for="duga_app_id" class="form-label">DUGA アプリケーションID</label>
                        <input type="text" class="form-control" id="duga_app_id" name="duga_app_id" 
                               value="<?php echo htmlspecialchars($config['duga']['app_id'] ?? ''); ?>"
                               placeholder="例: mxTIHSMnHIepewkDxjN4">
                        <small class="text-muted">DUGA APIアクセスに必要</small>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="duga_agent_id" class="form-label">DUGA 代理店ID</label>
                            <input type="text" class="form-control" id="duga_agent_id" name="duga_agent_id" 
                                   value="<?php echo htmlspecialchars($config['duga']['agent_id'] ?? ''); ?>"
                                   placeholder="代理店IDを入力">
                        </div>
                        <div class="col-md-6">
                            <label for="duga_banner_id" class="form-label">DUGA バナーID</label>
                            <input type="text" class="form-control" id="duga_banner_id" name="duga_banner_id" 
                                   value="<?php echo htmlspecialchars($config['duga']['banner_id'] ?? ''); ?>"
                                   placeholder="01～99の好きな番号">
                            <small class="text-muted">01～99の好きな番号を選んでください</small>
                        </div>
                    </div>
                    <small class="text-muted d-block mb-3">DUGAの商品情報取得に使用</small>
                    
                    <div class="mb-3">
                        <label for="venice_api_key" class="form-label">Venice AI API Key</label>
                        <input type="password" class="form-control" id="venice_api_key" name="venice_api_key" 
                               placeholder="<?php 
                                   $hasVenice = (!empty($config['api_keys']['venice']) && $config['api_keys']['venice'] !== '') || 
                                              (!empty($config['venice_api_key']) && $config['venice_api_key'] !== '');
                                   echo $hasVenice ? '設定済み（変更する場合は新しいキーを入力）' : 'Venice APIキーを入力'; 
                               ?>">
                        <small class="text-muted">Venice AIでの記事生成に使用</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="perplexity_api_key" class="form-label">Perplexity API Key</label>
                        <input type="password" class="form-control" id="perplexity_api_key" name="perplexity_api_key" 
                               placeholder="<?php 
                                   $hasPerplexity = (!empty($config['api_keys']['perplexity']) && $config['api_keys']['perplexity'] !== '') || 
                                                   (!empty($config['perplexity_api_key']) && $config['perplexity_api_key'] !== '');
                                   echo $hasPerplexity ? '設定済み（変更する場合は新しいキーを入力）' : 'pplx-...'; 
                               ?>">
                        <small class="text-muted">Perplexityでの情報収集に使用（オプション）</small>
                    </div>
                </div>
            </div>
            
        </div>
        
        <div class="col-lg-4">
            <!-- セキュリティ設定 -->
            <div class="card mb-3">
                <div class="card-header py-2">
                    <h5 class="mb-0"><i class="bi bi-shield-lock"></i> セキュリティ設定</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="current_password" class="form-label">現在のパスワード</label>
                        <input type="password" class="form-control" id="current_password" name="current_password">
                        <small class="text-muted">パスワードを変更する場合は必須</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="new_password" class="form-label">新しいパスワード</label>
                        <input type="password" class="form-control" id="new_password" name="new_password" 
                               pattern=".{8,}" title="8文字以上で入力してください">
                        <small class="text-muted">8文字以上で設定してください</small>
                    </div>
                    
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">新しいパスワード（確認）</label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password">
                        <small class="text-muted">確認のため再度入力</small>
                    </div>
                </div>
            </div>
            
            <!-- 保存ボタン -->
            <div class="d-grid">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="bi bi-save"></i> 設定を保存
                </button>
            </div>
        </div>
    </div>
</form>

<style>
/* 設定画面の余白調整 */
.card-body {
    padding: 1rem;
}

.mb-3 {
    margin-bottom: 0.75rem !important;
}

.form-label {
    margin-bottom: 0.25rem;
    font-size: 0.9rem;
}

.small {
    font-size: 0.8rem;
}
</style>