<?php
// セッションチェックは親ファイル（index.php）で行われているため、ここでは不要

// サイト設定の読み込み
$siteConfigFile = __DIR__ . '/../../data/site-configs.json';
$siteConfigs = [];
if (file_exists($siteConfigFile)) {
    $siteConfigs = json_decode(file_get_contents($siteConfigFile), true) ?: [];
}

// 編集対象のサイトIDを取得
$editSiteId = isset($_GET['site']) ? $_GET['site'] : '';
$currentSite = null;

// サイトが1つしかない場合は自動選択
if (empty($editSiteId) && count($siteConfigs) === 1) {
    $editSiteId = array_keys($siteConfigs)[0];
}

if ($editSiteId && isset($siteConfigs[$editSiteId])) {
    $currentSite = $siteConfigs[$editSiteId];
}

// 保存処理
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_settings'])) {
    if ($editSiteId && isset($siteConfigs[$editSiteId])) {
        // フリースペースの更新
        $siteConfigs[$editSiteId]['top_free_space'] = $_POST['top_free_space'] ?? '';
        $siteConfigs[$editSiteId]['bottom_free_space'] = $_POST['bottom_free_space'] ?? '';
        $siteConfigs[$editSiteId]['article_upper_free_space'] = $_POST['article_upper_free_space'] ?? '';
        $siteConfigs[$editSiteId]['article_free_space'] = $_POST['article_free_space'] ?? '';
        $siteConfigs[$editSiteId]['last_updated'] = date('Y-m-d H:i:s');
        
        // 保存
        if (file_put_contents($siteConfigFile, json_encode($siteConfigs, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
            $message = 'サイト設定を保存しました。';
            $messageType = 'success';
            $currentSite = $siteConfigs[$editSiteId];
        } else {
            $message = 'サイト設定の保存に失敗しました。';
            $messageType = 'danger';
        }
    }
}
?>

<div class="page-header">
    <h1><i class="bi bi-pencil-square"></i> サイトエディター</h1>
    <p class="text-muted">サイトのフリースペースを編集</p>
</div>

<?php if (isset($message)): ?>
    <div class="alert alert-<?php echo $messageType; ?> alert-dismissible fade show" role="alert">
        <i class="bi bi-<?php echo $messageType === 'success' ? 'check-circle' : 'exclamation-triangle'; ?>"></i> <?php echo htmlspecialchars($message); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (empty($siteConfigs)): ?>
    <div class="alert alert-warning">
        <h4>サイトが見つかりません</h4>
        <p>まずサイトを生成してから、編集を行ってください。</p>
        <a href="?page=site-generator" class="btn btn-primary">サイトを生成する</a>
    </div>
<?php else: ?>

<!-- サイト選択 -->
<?php if (count($siteConfigs) > 1): ?>
<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0"><i class="bi bi-globe"></i> 編集するサイトを選択</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <?php foreach ($siteConfigs as $siteId => $site): ?>
            <div class="col-md-4 mb-3">
                <div class="border rounded p-3 <?php echo $editSiteId === $siteId ? 'border-primary bg-light' : ''; ?>">
                    <h6><?php echo htmlspecialchars($site['display_name']); ?></h6>
                    <small class="text-muted d-block"><?php echo htmlspecialchars($site['url']); ?></small>
                    <small class="text-muted d-block">最終更新: <?php echo date('Y/m/d H:i', strtotime($site['last_updated'] ?? $site['created_at'])); ?></small>
                    <a href="?page=site-editor&site=<?php echo urlencode($siteId); ?>" class="btn btn-sm btn-primary mt-2">
                        <i class="bi bi-pencil"></i> 編集
                    </a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- 編集フォーム -->
<?php if ($currentSite): ?>
<form method="POST">
    <input type="hidden" name="save_settings" value="1">
    
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="bi bi-pencil"></i> <?php echo htmlspecialchars($currentSite['display_name']); ?> の編集
            </h5>
        </div>
        <div class="card-body">
            <div class="mb-4">
                <label class="form-label">
                    <i class="bi bi-house"></i> トップページ上部フリースペース
                </label>
                <small class="text-muted d-block mb-2">トップページのメインコンテンツ上部に表示されるHTMLコンテンツ</small>
                <textarea class="form-control tinymce-editor free-space" name="top_free_space" rows="8" 
                          id="top_free_space"><?php echo htmlspecialchars($currentSite['top_free_space'] ?? ''); ?></textarea>
            </div>
            
            <div class="mb-4">
                <label class="form-label">
                    <i class="bi bi-house"></i> トップページ下部フリースペース
                </label>
                <small class="text-muted d-block mb-2">トップページのメインコンテンツ下部に表示されるHTMLコンテンツ</small>
                <textarea class="form-control tinymce-editor free-space" name="bottom_free_space" rows="8" 
                          id="bottom_free_space"><?php echo htmlspecialchars($currentSite['bottom_free_space'] ?? ''); ?></textarea>
            </div>
            
            <div class="mb-4">
                <label class="form-label">
                    <i class="bi bi-file-text"></i> 記事ページ上部フリースペース
                </label>
                <small class="text-muted d-block mb-2">各記事ページの記事本文上部に表示されるHTMLコンテンツ</small>
                <textarea class="form-control tinymce-editor free-space" name="article_upper_free_space" rows="8" 
                          id="article_upper_free_space"><?php echo htmlspecialchars($currentSite['article_upper_free_space'] ?? ''); ?></textarea>
            </div>
            
            <div class="mb-4">
                <label class="form-label">
                    <i class="bi bi-file-text"></i> 記事ページ下部フリースペース
                </label>
                <small class="text-muted d-block mb-2">各記事ページの記事本文下部に表示されるHTMLコンテンツ</small>
                <textarea class="form-control tinymce-editor free-space" name="article_free_space" rows="8" 
                          id="article_free_space"><?php echo htmlspecialchars($currentSite['article_free_space'] ?? ''); ?></textarea>
            </div>
            
            <div class="text-end">
                <a href="?page=site-generator&edit=<?php echo urlencode($editSiteId); ?>" class="btn btn-secondary">
                    <i class="bi bi-gear"></i> サイト設定を編集
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> 変更を保存
                </button>
            </div>
        </div>
    </div>
</form>

<!-- TinyMCE設定 -->
<script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
tinymce.init({
    selector: '.tinymce-editor',
    language: 'ja',
    height: 300,
    menubar: false,
    plugins: [
        'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
        'searchreplace', 'visualblocks', 'code', 'fullscreen',
        'insertdatetime', 'media', 'table', 'code', 'help', 'wordcount'
    ],
    toolbar: 'undo redo | blocks | ' +
        'bold italic underline strikethrough | alignleft aligncenter ' +
        'alignright alignjustify | bullist numlist outdent indent | ' +
        'forecolor backcolor | link image media | code removeformat | help',
    content_style: 'body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; font-size: 14px; line-height: 1.6; }',
    promotion: false,
    branding: false,
    
    // 日本語設定
    language_url: 'https://cdn.jsdelivr.net/npm/tinymce-i18n@23.10.9/langs6/ja.js',
    
    // コード編集モードの設定
    code_dialog_height: 300,
    code_dialog_width: 800,
    
    // 画像アップロード設定（ローカルアップロードを無効化）
    automatic_uploads: false,
    
    // リンクの設定
    link_default_target: '_blank',
    link_assume_external_targets: true,
    
    // テーブルの設定
    table_default_attributes: {
        border: '1'
    },
    table_default_styles: {
        width: '100%'
    },
    
    // プレビューの設定
    preview_styles: 'font-size color background-color',
    
    // その他の設定
    convert_urls: false,
    relative_urls: false,
    remove_script_host: false,
    entity_encoding: 'raw',
    extended_valid_elements: 'script[src|type|async|defer],style[type],link[rel|href|type]',
    valid_children: '+body[style|script|link]',
    
    // カスタムフォーマット
    formats: {
        alignleft: { selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img', classes: 'text-left' },
        aligncenter: { selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img', classes: 'text-center' },
        alignright: { selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table,img', classes: 'text-right' },
        alignjustify: { selector: 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,table', classes: 'text-justify' }
    },
    
    // テンプレート
    templates: [
        {
            title: '広告バナー（中央寄せ）',
            description: '中央寄せの広告バナー用HTMLテンプレート',
            content: '<div style="text-align: center; margin: 20px 0;">\n<!-- 広告コードをここに貼り付け -->\n</div>'
        },
        {
            title: 'お知らせボックス',
            description: '目立つお知らせボックス',
            content: '<div style="background-color: #f0f8ff; border: 2px solid #4169e1; border-radius: 8px; padding: 15px; margin: 20px 0;">\n<strong>お知らせ：</strong>ここにお知らせ内容を入力\n</div>'
        },
        {
            title: '関連リンクリスト',
            description: '関連リンクのリスト表示',
            content: '<div style="background-color: #f5f5f5; padding: 15px; border-radius: 5px; margin: 20px 0;">\n<h4>関連リンク</h4>\n<ul>\n<li><a href="#" target="_blank">リンク1</a></li>\n<li><a href="#" target="_blank">リンク2</a></li>\n<li><a href="#" target="_blank">リンク3</a></li>\n</ul>\n</div>'
        }
    ],
    
    // ツールバーにテンプレートボタンを追加
    setup: function(editor) {
        editor.ui.registry.addButton('templates', {
            text: 'テンプレート',
            icon: 'template',
            onAction: function() {
                editor.execCommand('mceInsertTemplate');
            }
        });
    },
    
    toolbar: 'undo redo | blocks | ' +
        'bold italic underline strikethrough | alignleft aligncenter ' +
        'alignright alignjustify | bullist numlist outdent indent | ' +
        'forecolor backcolor | link image media | templates | code removeformat | help'
});
</script>

<style>
.tox-tinymce {
    border: 1px solid #ced4da !important;
    border-radius: 0.375rem !important;
}

.tox-toolbar__primary {
    background-color: #f8f9fa !important;
    border-bottom: 1px solid #dee2e6 !important;
}

.tox-edit-area {
    padding: 0.375rem !important;
}

.card-header h5 {
    margin-bottom: 0;
}

.form-label {
    font-weight: 600;
    margin-bottom: 0.5rem;
}
</style>

<?php else: ?>
    <?php if (count($siteConfigs) === 1): ?>
        <div class="alert alert-danger">
            選択されたサイトが見つかりません。
        </div>
    <?php endif; ?>
<?php endif; ?>

<?php endif; ?>