// 新しいタブで生成する機能を追加
function generateInNewTab() {
    const form = document.getElementById('generateForm');
    
    // フォームのバリデーションチェック
    if (!form.checkValidity()) {
        form.reportValidity();
        return;
    }
    
    // 現在のフォームデータを収集
    const formData = {
        title: document.getElementById('title').value,
        keywords: document.getElementById('keywords').value || '',
        model: document.getElementById('model').value,
        user_prompt: document.getElementById('user_prompt').value,
        temperature: document.getElementById('temperature')?.value || 0.7,
        max_tokens: document.getElementById('max_tokens')?.value || 2000
    };
    
    // 新しいウィンドウでgenerate.phpを開く
    const newWindow = window.open('?page=generate', '_blank');
    
    // 新しいウィンドウが読み込まれたら自動実行
    if (newWindow) {
        // LocalStorageを使ってデータを渡す
        localStorage.setItem('pendingGeneration', JSON.stringify({
            data: formData,
            timestamp: Date.now()
        }));
    }
}

// ページ読み込み時に自動生成をチェック
document.addEventListener('DOMContentLoaded', function() {
    // LocalStorageから保留中の生成をチェック
    const pendingData = localStorage.getItem('pendingGeneration');
    
    if (pendingData) {
        try {
            const { data, timestamp } = JSON.parse(pendingData);
            
            // 5秒以内のデータのみ処理（古いデータは無視）
            if (Date.now() - timestamp < 5000) {
                // フォームに値を設定
                if (document.getElementById('title')) {
                    document.getElementById('title').value = data.title;
                }
                if (document.getElementById('keywords')) {
                    document.getElementById('keywords').value = data.keywords;
                }
                if (document.getElementById('model')) {
                    document.getElementById('model').value = data.model;
                }
                if (document.getElementById('user_prompt')) {
                    document.getElementById('user_prompt').value = data.user_prompt;
                }
                if (document.getElementById('temperature')) {
                    document.getElementById('temperature').value = data.temperature;
                    document.getElementById('temperatureValue').textContent = data.temperature;
                }
                if (document.getElementById('max_tokens')) {
                    document.getElementById('max_tokens').value = data.max_tokens;
                }
                
                // LocalStorageをクリア
                localStorage.removeItem('pendingGeneration');
                
                // 少し待ってから自動的に生成開始
                setTimeout(() => {
                    console.log('Auto-generating from new tab...');
                    const generateBtn = document.getElementById('generateBtn');
                    if (generateBtn) {
                        generateBtn.click();
                    }
                }, 500);
            } else {
                // 古いデータは削除
                localStorage.removeItem('pendingGeneration');
            }
        } catch (e) {
            console.error('Error processing pending generation:', e);
            localStorage.removeItem('pendingGeneration');
        }
    }
});