// ポップアップウィンドウで記事生成
function generateInNewTab() {
    // 新しいウィンドウを開く
    const newWindow = window.open('', '_blank', 'width=800,height=600');
    
    // 新しいウィンドウに直接HTMLを書き込む
    newWindow.document.write(`
<!DOCTYPE html>
<html>
<head>
    <title>記事生成</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-4">
        <h1>記事生成（新しいウィンドウ）</h1>
        <form id="popupForm">
            <div class="mb-3">
                <label>タイトル</label>
                <input type="text" class="form-control" id="title" required>
            </div>
            <div class="mb-3">
                <label>内容</label>
                <textarea class="form-control" id="content" rows="5" required></textarea>
            </div>
            <button type="submit" class="btn btn-primary">生成</button>
        </form>
        <div id="result" class="mt-4"></div>
    </div>
    <script>
        document.getElementById('popupForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            document.getElementById('result').innerHTML = '<div class="alert alert-info">生成中...</div>';
            
            // ここでAPIを呼び出す
            // 実装は省略
            
            setTimeout(() => {
                document.getElementById('result').innerHTML = '<div class="alert alert-success">生成完了！（デモ）</div>';
            }, 2000);
        });
    </script>
</body>
</html>
    `);
    
    newWindow.document.close();
}